package org.sterling.source.scanner;

import static java.lang.Character.isWhitespace;
import static org.sterling.source.scanner.ScannerUtil.unexpectedInput;

import org.sterling.SterlingException;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class TerminatorScanner implements ScannerDelegate {

    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        skipWhitespace(reader);
        boolean expected = reader.expect('\n') || reader.expect(';');
        reader.reject();
        return expected;
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        if (expect(kind, reader)) {
            skipWhitespace(reader);
            reader.store();
            return reader.accept(kind);
        }
        throw unexpectedInput(reader, kind);
    }

    private void skipWhitespace(InputReader reader) {
        while (isWhitespace(reader.peek()) && !reader.expect('\n')) {
            reader.skip();
        }
    }
}
