package org.sterling.source.scanner;

import org.sterling.SterlingException;
import org.sterling.source.exception.ScannerException;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class WhitespaceSkippingScanner implements ScannerDelegate {

    private final ScannerDelegate delegate;

    public WhitespaceSkippingScanner(ScannerDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        reader.skipWhitespace();
        boolean expected = delegate.expect(kind, reader);
        reader.reject();
        return expected;
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        reader.skipWhitespace();
        try {
            return delegate.require(kind, reader);
        } catch (ScannerException exception) {
            reader.reject();
            throw exception;
        }
    }
}
