package org.sterling.source.syntax;

public abstract class AbstractLiteral<T extends Token> extends SourceNode {

    private final Class<T> tokenType;

    public AbstractLiteral(NodeKind kind, Class<T> tokenType) {
        super(kind);
        this.tokenType = tokenType;
    }

    public T getLiteral() {
        return tokenType.cast(getChildAt(0).getToken());
    }
}
