package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class ArgumentsExpression extends SourceNode {

    public ArgumentsExpression(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitArgumentsExpression(this, state);
    }

    public SourceNode getArgument() {
        return getChildAt(0);
    }

    public SourceNode getTail() {
        return getChildAt(1);
    }
}
