package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class BinaryExpressionTail extends SourceNode {

    public BinaryExpressionTail(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitBinaryExpressionTail(this, state);
    }

    public SourceNode getOperand() {
        return getChildAt(1);
    }

    public Token getOperator() {
        return getChildAt(0).getToken();
    }

    public SourceNode getTail() {
        return getChildAt(2);
    }
}
