package org.sterling.source.syntax;

import java.util.Objects;

public class BooleanToken extends Token {

    private final boolean booleanValue;

    public BooleanToken(Token token, boolean booleanValue) {
        super(token.getKind(), token.getValue(), token.getRange());
        this.booleanValue = booleanValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (o instanceof BooleanToken) {
            BooleanToken other = (BooleanToken) o;
            return super.equals(other)
                && Objects.equals(booleanValue, other.booleanValue);
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), booleanValue);
    }

    public boolean isTrue() {
        return booleanValue;
    }

    @Override
    public String toString() {
        return super.toString() + " raw=[" + booleanValue + "]";
    }
}
