package org.sterling.source.syntax;

import java.util.Objects;

public class CharacterToken extends Token {

    private final char charValue;

    public CharacterToken(Token token, char charValue) {
        super(token.getKind(), token.getValue(), token.getRange());
        this.charValue = charValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (o instanceof CharacterToken) {
            CharacterToken other = (CharacterToken) o;
            return super.equals(other)
                && charValue == other.charValue;
        } else {
            return false;
        }
    }

    public char getCharValue() {
        return charValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), charValue);
    }

    @Override
    public String toString() {
        return super.toString() + " raw=[" + charValue + "]";
    }
}
