package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class Declaration extends SourceNode {

    public Declaration(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitDeclaration(this, state);
    }

    public String getIdentifier() {
        return getChildAt(0).getToken().getValue();
    }

    public SourceNode getTail() {
        return getChildAt(2);
    }
}
