package org.sterling.source.syntax;

import java.util.Objects;

public class DoubleToken extends Token {

    private final double doubleValue;

    public DoubleToken(Token token, double doubleValue) {
        super(token.getKind(), token.getValue(), token.getRange());
        this.doubleValue = doubleValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (o instanceof DoubleToken) {
            DoubleToken other = (DoubleToken) o;
            return super.equals(other)
                && Objects.equals(doubleValue, other.doubleValue);
        } else {
            return false;
        }
    }

    public double getDoubleValue() {
        return doubleValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), doubleValue);
    }

    @Override
    public String toString() {
        return super.toString() + " raw=[" + doubleValue + "]";
    }
}
