package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class FromIdentifierList extends SourceNode {

    public FromIdentifierList(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitFromIdentifierList(this, state);
    }

    public SourceNode getAlias() {
        if (hasAlias()) {
            return getChildAt(1);
        } else {
            return VOID;
        }
    }

    public SourceNode getTail() {
        if (hasAlias()) {
            return getChildAt(2);
        } else {
            return getChildAt(1);
        }
    }

    public String getValue() {
        return getChildAt(0).getToken().getValue();
    }

    public boolean hasAlias() {
        return childrenSize() > 2;
    }
}
