package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class FromIdentifiers extends SourceNode {

    public FromIdentifiers(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitFromIdentifiers(this, state);
    }

    public SourceNode getList() {
        if (childrenSize() > 1) {
            return getChildAt(1);
        } else {
            return getChildAt(0);
        }
    }
}
