package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class FunctionArguments extends SourceNode {

    public FunctionArguments(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitFunctionArguments(this, state);
    }

    public SourceNode getArgument() {
        return getChildAt(0);
    }

    public SourceNode getTail() {
        return getChildAt(1);
    }
}
