package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class FunctionArgumentsTail extends SourceNode {

    public FunctionArgumentsTail(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitFunctionArgumentsTail(this, state);
    }

    public SourceNode getArgument() {
        return getChildAt(0);
    }

    public SourceNode getTail() {
        return getChildAt(1);
    }
}
