package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class FunctionLiteral extends SourceNode {

    public FunctionLiteral(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitFunctionLiteral(this, state);
    }

    public SourceNode getArguments() {
        return getChildAt(1);
    }

    public SourceNode getExpression() {
        return getChildAt(4);
    }
}
