package org.sterling.source.syntax;

import org.sterling.SterlingException;
import org.sterling.source.LocationRange;

public class ImportHeaders extends SourceNode {

    public ImportHeaders(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitImportHeaders(this, state);
    }

    public SourceNode getHeader() {
        return getChildAt(0);
    }

    @Override
    public LocationRange getRange() {
        return isDeclared() ? super.getRange() : LocationRange.NULL;
    }

    public boolean isDeclared() {
        return !super.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}
