package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class ImportIdentifier extends SourceNode {

    public ImportIdentifier(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitImportIdentifier(this, state);
    }

    public SourceNode getAlias() {
        return getChildAt(2);
    }

    public SourceNode getTail() {
        return getChildAt(1);
    }

    public String getValue() {
        return getChildAt(0).getToken().getValue();
    }
}
