package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class ImportIdentifierTail extends SourceNode {

    public ImportIdentifierTail(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitImportIdentifierTail(this, state);
    }

    public SourceNode getTail() {
        return getChildAt(2);
    }

    public String getValue() {
        return getChildAt(1).getToken().getValue();
    }

    public boolean hasTail() {
        return !getTail().isEmpty();
    }
}
