package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class IndexerArguments extends SourceNode {

    public IndexerArguments(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitIndexerArguments(this, state);
    }

    public SourceNode getArgument() {
        return getChildAt(0);
    }

    public SourceNode getSuffix() {
        return getChildAt(1);
    }
}
