package org.sterling.source.syntax;

import java.util.Objects;

public class IntegerToken extends Token {

    private final int intValue;

    public IntegerToken(Token token, int intValue) {
        super(token.getKind(), token.getValue(), token.getRange());
        this.intValue = intValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (o instanceof IntegerToken) {
            IntegerToken other = (IntegerToken) o;
            return super.equals(other)
                && intValue == other.intValue;
        } else {
            return false;
        }
    }

    public int getIntValue() {
        return intValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), intValue);
    }

    @Override
    public String toString() {
        return super.toString() + " raw=[" + intValue + "]";
    }
}
