package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class LambdaLiteral extends SourceNode {

    public LambdaLiteral(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitLambdaLiteral(this, state);
    }

    public SourceNode getArgument() {
        return getChildAt(0);
    }

    public SourceNode getExpression() {
        return getChildAt(2);
    }
}
