package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class ModuleDeclaration extends SourceNode {

    public ModuleDeclaration(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitModuleDeclaration(this, state);
    }

    public SourceNode getModuleHeader() {
        return getChildAt(0);
    }

    public SourceNode getUseHeaders() {
        return getChildAt(1);
    }

    public SourceNode getDeclarations() {
        return getChildAt(2);
    }
}
