package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class ModuleIdentifier extends SourceNode {

    public ModuleIdentifier(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitModuleIdentifier(this, state);
    }

    public SourceNode getTail() {
        return getChildAt(1);
    }

    public String getValue() {
        return getChildAt(0).getToken().getValue();
    }
}
