package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class ObjectArgument extends SourceNode {

    public ObjectArgument(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitObjectArgument(this, state);
    }

    public String getValue() {
        return getChildAt(0).getToken().getValue();
    }
}
