package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class ObjectArguments extends SourceNode {

    public ObjectArguments(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitObjectArguments(this, state);
    }

    public SourceNode getList() {
        return getChildAt(1);
    }

    public boolean hasList() {
        return childrenSize() > 2;
    }
}
