package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class ObjectArgumentsList extends SourceNode {

    public ObjectArgumentsList(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitObjectArgumentsList(this, state);
    }

    public SourceNode getArgument() {
        return getChildAt(0);
    }

    public SourceNode getList() {
        return getChildAt(1);
    }
}
