package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class ObjectHeader extends SourceNode {

    public ObjectHeader(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitObjectHeader(this, state);
    }

    public SourceNode getArguments() {
        return getChildAt(0);
    }

    public boolean isDeclared() {
        return !super.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}
