package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class ObjectLiteral extends SourceNode {

    public ObjectLiteral(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitObjectLiteral(this, state);
    }

    public SourceNode getHeader() {
        if (hasHeader()) {
            return getChildAt(1);
        } else {
            return VOID;
        }
    }

    public SourceNode getBody() {
        if (hasHeader()) {
            return getChildAt(2);
        } else {
            return getChildAt(1);
        }
    }

    public boolean hasHeader() {
        return childrenSize() > 2;
    }
}
