package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class ObjectMember extends SourceNode {

    public ObjectMember(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitObjectMember(this, state);
    }

    public String getName() {
        return getChildAt(0).getToken().getValue();
    }

    public SourceNode getLambda() {
        return getChildAt(2);
    }
}
