package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class QualifiedIdentifier extends SourceNode {

    public QualifiedIdentifier(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitQualifiedIdentifier(this, state);
    }

    public Token getIdentifier() {
        return getChildAt(0).getToken();
    }

    public SourceNode getTail() {
        return getChildAt(1);
    }
}
