package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class QualifiedIdentifierTail extends SourceNode {

    public QualifiedIdentifierTail(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitQualifiedIdentifierTail(this, state);
    }

    public Token getIdentifier() {
        return getChildAt(1).getToken();
    }

    public SourceNode getTail() {
        return getChildAt(2);
    }

    public boolean hasTail() {
        return !getTail().isEmpty();
    }
}
