package org.sterling.source.syntax;

import org.sterling.SterlingException;

public interface SourceVisitor<R, S> {

    R visit(SourceNode node, S state) throws SterlingException;

    R visitAccessorExpression(AccessorExpression accessor, S state) throws SterlingException;

    R visitApplyExpression(ApplyExpression expression, S state) throws SterlingException;

    R visitArgument(ArgumentExpression argument, S state) throws SterlingException;

    R visitArgumentsExpression(ArgumentsExpression arguments, S state) throws SterlingException;

    R visitArgumentsExpressionTail(ArgumentsExpressionTail tail, S state) throws SterlingException;

    R visitBinaryExpression(BinaryExpression binary, S state) throws SterlingException;

    R visitBinaryExpressionTail(BinaryExpressionTail tail, S state) throws SterlingException;

    R visitBooleanLiteral(BooleanLiteral literal, S state) throws SterlingException;

    R visitCharacterLiteral(CharacterLiteral literal, S state) throws SterlingException;

    R visitConstantExpression(ConstantExpression lambda, S state) throws SterlingException;

    R visitDeclaration(Declaration lambda, S state) throws SterlingException;

    R visitDeclarationLiteral(DeclarationLiteral tail, S state) throws SterlingException;

    R visitDeclarationSequence(DeclarationSequence sequence, S state) throws SterlingException;

    R visitDeclarationSequenceTail(DeclarationSequenceTail tail, S state) throws SterlingException;

    R visitDoubleLiteral(DoubleLiteral literal, S state) throws SterlingException;

    R visitExpression(SourceExpression expression, S state) throws SterlingException;

    R visitFromIdentifier(FromIdentifier identifier, S state) throws SterlingException;

    R visitFromIdentifierAlias(ImportIdentifierAlias alias, S state) throws SterlingException;

    R visitFromIdentifierList(FromIdentifierList list, S state) throws SterlingException;

    R visitFromIdentifierListTail(FromIdentifierListTail tail, S state) throws SterlingException;

    R visitFromIdentifierTail(FromIdentifierTail tail, S state) throws SterlingException;

    R visitFromIdentifiers(FromIdentifiers identifiers, S state) throws SterlingException;

    R visitFromStatement(FromStatement from, S state) throws SterlingException;

    R visitFunctionArguments(FunctionArguments arguments, S state) throws SterlingException;

    R visitFunctionArgumentsTail(FunctionArgumentsTail list, S state) throws SterlingException;

    R visitFunctionLiteral(FunctionLiteral lambda, S state) throws SterlingException;

    R visitImportHeader(ImportHeader header, S state) throws SterlingException;

    R visitImportHeaderSuffix(ImportHeaderSuffix suffix, S state) throws SterlingException;

    R visitImportHeaderTail(ImportHeaderTail tail, S state) throws SterlingException;

    R visitImportHeaders(ImportHeaders headers, S state) throws SterlingException;

    R visitImportIdentifier(ImportIdentifier identifier, S state) throws SterlingException;

    R visitImportIdentifierTail(ImportIdentifierTail tail, S state) throws SterlingException;

    R visitImportStatement(ImportStatement importStatement, S state) throws SterlingException;

    R visitIndexerArgument(IndexerArgument argument, S state) throws SterlingException;

    R visitIndexerArguments(IndexerArguments arguments, S state) throws SterlingException;

    R visitIndexerArgumentsSuffix(IndexerArgumentsSuffix suffix, S state) throws SterlingException;

    R visitIndexerArgumentsTail(IndexerArgumentsTail tail, S state) throws SterlingException;

    R visitIndexerExpression(IndexerExpression indexer, S state) throws SterlingException;

    R visitIntegerLiteral(IntegerLiteral integer, S state) throws SterlingException;

    R visitJavaExpression(JavaExpression expression, S state) throws SterlingException;

    R visitLambdaArgument(LambdaArgument argument, S state) throws SterlingException;

    R visitLambdaLiteral(LambdaLiteral lambda, S state) throws SterlingException;

    R visitLiteralExpression(LiteralExpression literal, S state) throws SterlingException;

    R visitModuleDeclaration(ModuleDeclaration program, S state) throws SterlingException;

    R visitModuleHeader(ModuleHeader header, S state) throws SterlingException;

    R visitModuleIdentifier(ModuleIdentifier identifier, S state) throws SterlingException;

    R visitModuleIdentifierTail(ModuleIdentifierTail tail, S state) throws SterlingException;

    R visitNullLiteral(NullLiteral literal, S state) throws SterlingException;

    R visitObjectArgument(ObjectArgument argument, S state) throws SterlingException;

    R visitObjectArguments(ObjectArguments arguments, S state) throws SterlingException;

    R visitObjectArgumentsList(ObjectArgumentsList arguments, S state) throws SterlingException;

    R visitObjectBody(ObjectBody body, S state) throws SterlingException;

    R visitObjectHeader(ObjectHeader header, S state) throws SterlingException;

    R visitObjectLiteral(ObjectLiteral literal, S state) throws SterlingException;

    R visitObjectMember(ObjectMember member, S state) throws SterlingException;

    R visitObjectMemberName(ObjectMemberName name, S state) throws SterlingException;

    R visitObjectMembers(ObjectMembers members, S state) throws SterlingException;

    R visitObjectMembersSuffix(ObjectMembersSuffix suffix, S state) throws SterlingException;

    R visitObjectMembersTail(ObjectMembersTail tail, S state) throws SterlingException;

    R visitParentheticalExpression(ParentheticalExpression parenthetical, S state) throws SterlingException;

    R visitPrimaryExpression(PrimaryExpression primary, S state) throws SterlingException;

    R visitQualifiedIdentifier(QualifiedIdentifier qualified, S state) throws SterlingException;

    R visitQualifiedIdentifierTail(QualifiedIdentifierTail tail, S state) throws SterlingException;

    R visitSelectorExpression(SelectorExpression selector, S state) throws SterlingException;

    R visitSelectorExpressionTail(SelectorExpressionTail tail, S state) throws SterlingException;

    R visitSingleObjectArgument(SingleObjectArgument argument, S state) throws SterlingException;

    R visitStringLiteral(StringLiteral literal, S state) throws SterlingException;

    R visitTernaryExpression(TernaryExpression ternary, S state) throws SterlingException;

    R visitTernaryExpressionTail(TernaryExpressionTail tail, S state) throws SterlingException;

    R visitUnaryExpression(UnaryExpression unary, S state) throws SterlingException;
}
