package org.sterling.source.syntax;

import java.util.Objects;

public class StringToken extends Token {

    private final String stringValue;

    public StringToken(Token token, String stringValue) {
        super(token.getKind(), token.getValue(), token.getRange());
        this.stringValue = stringValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (o instanceof StringToken) {
            StringToken other = (StringToken) o;
            return super.equals(other)
                && Objects.equals(stringValue, other.stringValue);
        } else {
            return false;
        }
    }

    public String getStringValue() {
        return stringValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), stringValue);
    }
}
