package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class TernaryExpression extends SourceNode {

    public TernaryExpression(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitTernaryExpression(this, state);
    }

    public SourceNode getCondition() {
        return getChildAt(1);
    }

    public SourceNode getTruePath() {
        return getChildAt(3);
    }

    public SourceNode getFalsePath() {
        return getChildAt(5);
    }
}
