package org.sterling.source.syntax;

import org.sterling.SterlingException;

public class UnaryExpression extends SourceNode {

    public UnaryExpression(NodeKind kind) {
        super(kind);
    }

    @Override
    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return visitor.visitUnaryExpression(this, state);
    }

    public SourceNode getOperand() {
        if (hasOperator()) {
            return getChildAt(1);
        } else {
            return getChildAt(0);
        }
    }

    public Token getOperator() {
        if (hasOperator()) {
            return getChildAt(0).getToken();
        } else {
            return Token.NULL;
        }
    }

    public boolean hasOperator() {
        return getChildren().size() > 1;
    }
}
