package org.sterling.source.translator;

import java.util.*;

public class AliasBuilder {

    private final List<String> from;
    private final List<String> imports;
    private final Map<String, String> aliases;

    public AliasBuilder() {
        from = new ArrayList<>();
        imports = new ArrayList<>();
        aliases = new HashMap<>();
    }

    public void addImport(String importName) {
        imports.add(importName);
        setAlias(importName);
    }

    public void appendFrom(String modulePart) {
        from.add(modulePart);
    }

    public List<Alias> acceptImports() {
        String module = acceptModule();
        List<Alias> accepted = acceptImports(module);
        reset();
        return accepted;
    }

    public void setAlias(String alias) {
        aliases.put(imports.get(imports.size() - 1), alias);
    }

    private List<Alias> acceptImports(String module) {
        List<Alias> imports = new ArrayList<>();
        for (String importName : this.imports) {
            imports.add(new Alias(module + '/' + importName, aliases.get(importName)));
        }
        return imports;
    }

    private String acceptModule() {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = from.iterator();
        builder.append(iterator.next());
        while (iterator.hasNext()) {
            builder.append('/');
            builder.append(iterator.next());
        }
        from.clear();
        return builder.toString();
    }

    private void reset() {
        from.clear();
        imports.clear();
    }
}
