package org.sterling.source.translator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModuleBuilder {

    private State state;

    public ModuleBuilder() {
        state = new BuildState();
    }

    public void acceptModule() {
        state = new AcceptState(state.getModule());
    }

    public void appendModule(String part) {
        state.appendModule(part);
    }

    public String getIdentifier() {
        return state.getModule();
    }

    public boolean isDeclared() {
        return state.isDeclared();
    }

    private interface State {

        void appendModule(String part);

        boolean isDeclared();

        String getModule();
    }

    private static final class AcceptState implements State {

        private final String module;

        public AcceptState(String module) {
            this.module = module;
        }

        @Override
        public void appendModule(String modulePart) {
            throw new IllegalStateException();
        }

        @Override
        public boolean isDeclared() {
            return true;
        }

        @Override
        public String getModule() {
            return module;
        }
    }

    private static final class BuildState implements State {

        private final List<String> parts;

        public BuildState() {
            parts = new ArrayList<>();
        }

        @Override
        public void appendModule(String modulePart) {
            parts.add(modulePart);
        }

        @Override
        public boolean isDeclared() {
            return false;
        }

        @Override
        public String getModule() {
            StringBuilder builder = new StringBuilder();
            Iterator<String> iterator = parts.iterator();
            if (iterator.hasNext()) {
                builder.append(iterator.next());
                while (iterator.hasNext()) {
                    builder.append('/');
                    builder.append(iterator.next());
                }
            }
            return builder.toString();
        }
    }
}
