package org.sterling.source.translator;

import static org.sterling.runtime.expression.ExpressionFactory.declaration;

import java.util.HashSet;
import java.util.Set;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ObjectExpression;

public class ObjectBuilder {

    private final Set<DeclaredExpression> members;

    public ObjectBuilder() {
        members = new HashSet<>();
    }

    public void declareMember(String identifier, Expression expression) {
        members.add(declaration(identifier, expression));
    }

    public Expression toObject() {
        return new ObjectExpression(members);
    }
}
