package org.sterling.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class BufferUtil {

    public static BufferedReader buffer(InputStream inputStream) {
        try {
            return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        } catch (IOException exception) {
            throw new BufferException(exception);
        }
    }

    private BufferUtil() {
        // intentionally empty
    }
}

class BufferException extends RuntimeException {

    public BufferException(Throwable cause) {
        super(cause);
    }
}
