package org.sterling.util;

import java.util.HashSet;
import java.util.Set;

public class VisitorTracker implements VisitorState {

    private final Set<Object> visiting;

    public VisitorTracker() {
        visiting = new HashSet<>();
    }

    @Override
    public void beginVisit(Object node) {
        if (!visiting.add(node)) {
            throw new IllegalVisitException("Detected circular visit to node: " + node.getClass().getSimpleName());
        }
    }

    @Override
    public void endVisit(Object node) {
        visiting.remove(node);
    }
}
