/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import org.sterling.SterlingException;
import org.sterling.runtime.Compiler;
import org.sterling.runtime.exception.LoadModuleException;
import org.sterling.runtime.exception.UndefinedMemberException;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionConversions;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.ModuleExpression;
import org.sterling.runtime.expression.Symbol;
import org.sterling.source.scanner.InputReader;
import org.sterling.util.StringUtil;

public class GlobalModule
extends Expression {
    private final Compiler compiler;
    private final Map<Symbol, DeclaredExpression> members;
    private final Set<Symbol> loadedMembers;
    private final ClassLoader classLoader;

    public GlobalModule(ClassLoader classLoader, Compiler compiler) {
        this.compiler = compiler;
        this.classLoader = classLoader;
        this.members = new ConcurrentHashMap<Symbol, DeclaredExpression>();
        this.loadedMembers = new CopyOnWriteArraySet<Symbol>();
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        Symbol symbol = ExpressionConversions.convertSymbol(member);
        if (!this.isDefined(symbol)) {
            try {
                return super.access(member);
            }
            catch (UndefinedMemberException exception) {
                this.load(symbol);
            }
        }
        return this.members.get(symbol).getExpression();
    }

    public Expression load(String name) throws SterlingException {
        Expression expression = this;
        for (String part : name.split(Pattern.quote("/"))) {
            expression = ((Expression)expression).access(ExpressionFactory.symbol(part));
        }
        return expression;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleExpression loadModule(Symbol module) throws SterlingException {
        URL url = this.getModuleUrl(module);
        if (url == null) {
            return ExpressionFactory.module(module, this);
        }
        try (InputReader reader = this.readSource(url);){
            ModuleExpression moduleExpression = ExpressionFactory.module(module, this, this.compiler.compile(reader, this));
            return moduleExpression;
        }
        catch (IOException exception) {
            throw new LoadModuleException(exception);
        }
    }

    public String toString() {
        return StringUtil.stringify(this, new Object[0]);
    }

    private boolean isDefined(Symbol symbol) {
        return this.members.containsKey(symbol);
    }

    private void load(Symbol subModule) throws SterlingException {
        if (!this.loadedMembers.contains(subModule)) {
            this.loadedMembers.add(subModule);
            this.members.put(subModule, ExpressionFactory.declaration(subModule, (Expression)this.loadModule(subModule)));
        }
    }

    private URL getModuleUrl(Symbol module) {
        String moduleName = module.getValue();
        URL url = this.classLoader.getResource(moduleName + ".ag");
        if (url == null) {
            url = this.classLoader.getResource(moduleName + "/_base.ag");
        }
        return url;
    }

    private InputReader readSource(URL url) throws SterlingException, IOException {
        return new InputReader(url.toString(), url.openStream());
    }
}

