/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.sterling.SterlingException;
import org.sterling.cli.CommandLineRunner;
import org.sterling.cli.RunnerException;
import org.sterling.runtime.Compiler;
import org.sterling.runtime.GlobalModule;

public class SterlingRunner
implements CommandLineRunner {
    private final ClassLoader delegateClassLoader = Thread.currentThread().getContextClassLoader();

    @Override
    public String getCommand() {
        return "run";
    }

    @Override
    public String getHelpText() {
        return "Runs the 'main' expression from a specified module";
    }

    @Override
    public void run(List<String> args) {
        try {
            ClassLoader classLoader = this.setModulePath(args);
            GlobalModule globalModule = new GlobalModule(classLoader, new Compiler());
            globalModule.load(this.getMain(args)).evaluate();
        }
        catch (IOException | SterlingException exception) {
            throw new RunnerException(exception);
        }
    }

    private String getMain(List<String> args) {
        if (args.size() < 1) {
            throw new RunnerException("No module specified");
        }
        int offset = args.size() > 1 ? 1 : 0;
        return args.get(offset).replace('.', '/') + "/main";
    }

    private List<String> listPaths(String paths) {
        ArrayList<String> pathList = new ArrayList<String>(Arrays.asList(paths.split(Pattern.quote(File.pathSeparator))));
        if (!pathList.contains(".")) {
            pathList.add(".");
        }
        return pathList;
    }

    private ClassLoader setModulePath(List<String> args) throws IOException {
        Iterator<String> iterator = args.iterator();
        while (iterator.hasNext()) {
            if (!"-mp".equals(iterator.next())) continue;
            iterator.remove();
            ClassLoader classLoader = this.setModulePath(iterator.next());
            iterator.remove();
            return classLoader;
        }
        return this.setModulePath(".");
    }

    private ClassLoader setModulePath(String paths) throws IOException {
        List<String> pathList = this.listPaths(paths);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : pathList) {
            urls.add(this.toUrl(path));
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), this.delegateClassLoader);
    }

    private URL toUrl(String path) throws IOException {
        return new File(path).toURI().toURL();
    }
}

