/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionVisitor;
import org.sterling.util.StringUtil;

public class AccessedExpression
extends Expression {
    private final Expression expression;
    private final Expression member;

    public AccessedExpression(Expression expression, Expression member) {
        this.expression = expression;
        this.member = member;
    }

    @Override
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitAccessExpression(this, data);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AccessedExpression) {
            AccessedExpression other = (AccessedExpression)o;
            return Objects.equals(this.expression, other.expression) && Objects.equals(this.member, other.member);
        }
        return false;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Expression getMember() {
        return this.member;
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.member);
    }

    @Override
    public Expression reduce() throws SterlingException {
        return this.expression.reduce().access(this.member);
    }

    public String toString() {
        return StringUtil.stringify(this, this.expression, this.member);
    }
}

