/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import org.sterling.SterlingException;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionConversions;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.IntegerConstant;
import org.sterling.runtime.expression.StringConstant;
import org.sterling.util.StringUtil;

public class BooleanConstant
extends Expression {
    public static BooleanConstant TRUE = new BooleanConstant(true);
    public static BooleanConstant FALSE = new BooleanConstant(false);
    private final boolean value;
    private final StringConstant stringValue;
    private final IntegerConstant integerValue;

    private BooleanConstant(boolean value) {
        this.value = value;
        this.stringValue = ExpressionFactory.constant(value ? "True" : "False");
        this.integerValue = ExpressionFactory.constant(value ? 1 : 0);
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        switch (ExpressionConversions.convertSymbol(member).getValue()) {
            case "toBoolean": {
                return this;
            }
            case "toString": {
                return this.stringValue;
            }
            case "toInteger": {
                return this.integerValue;
            }
        }
        return super.access(member);
    }

    public boolean isFalse() {
        return !this.isTrue();
    }

    public boolean isTrue() {
        return this.value;
    }

    public String toString() {
        return StringUtil.stringify(this, this.stringValue.getValue());
    }
}

