/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.BooleanConstant;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionConversions;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.IntegerConstant;
import org.sterling.util.StringUtil;

public class DoubleConstant
extends Expression {
    private final double value;

    public DoubleConstant(double value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DoubleConstant && this.value == ((DoubleConstant)o).value;
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        switch (ExpressionConversions.convertSymbol(member).getValue()) {
            case "+": {
                return new AddClosure(this.value);
            }
            case "-": {
                return new SubtractClosure(this.value);
            }
            case "*": {
                return new MultiplyClosure(this.value);
            }
            case "/": {
                return new DivideClosure(this.value);
            }
            case "%": {
                return new ModuloClosure(this.value);
            }
            case "positive": {
                return new DoubleConstant(Math.abs(this.value));
            }
            case "negative": {
                return new DoubleConstant(-this.value);
            }
            case "toBoolean": {
                return this.toBoolean();
            }
            case "toInteger": {
                return new IntegerConstant(Double.valueOf(this.value).intValue());
            }
            case "toDouble": {
                return this;
            }
            case "toString": {
                return ExpressionFactory.constant(Double.valueOf(this.value).toString());
            }
        }
        return super.access(member);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return StringUtil.stringify(this, this.value);
    }

    private BooleanConstant toBoolean() {
        return this.value == 1.0 ? BooleanConstant.TRUE : BooleanConstant.FALSE;
    }

    private static final class ModuloClosure
    extends DoubleClosure {
        public ModuloClosure(double value) {
            super(value);
        }

        @Override
        protected double operate(double leftValue, double rightValue) {
            return leftValue % rightValue;
        }
    }

    private static final class DivideClosure
    extends DoubleClosure {
        public DivideClosure(double value) {
            super(value);
        }

        @Override
        protected double operate(double leftValue, double rightValue) {
            return leftValue / rightValue;
        }
    }

    private static final class MultiplyClosure
    extends DoubleClosure {
        public MultiplyClosure(double value) {
            super(value);
        }

        @Override
        protected double operate(double leftValue, double rightValue) {
            return leftValue * rightValue;
        }
    }

    private static final class SubtractClosure
    extends DoubleClosure {
        public SubtractClosure(double value) {
            super(value);
        }

        @Override
        protected double operate(double leftValue, double rightValue) {
            return leftValue - rightValue;
        }
    }

    private static final class AddClosure
    extends DoubleClosure {
        public AddClosure(double value) {
            super(value);
        }

        @Override
        protected double operate(double leftValue, double rightValue) {
            return leftValue + rightValue;
        }
    }

    private static abstract class DoubleClosure
    extends Expression {
        private final double value;

        public DoubleClosure(double value) {
            this.value = value;
        }

        @Override
        public Expression apply(Expression argument) throws SterlingException {
            return new DoubleConstant(this.operate(this.value, ExpressionConversions.convertDouble(argument).value));
        }

        public String toString() {
            return StringUtil.stringify(this, this.value);
        }

        protected abstract double operate(double var1, double var3);
    }
}

