/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sterling.runtime.GlobalModule;
import org.sterling.runtime.expression.AccessedExpression;
import org.sterling.runtime.expression.AppliedExpression;
import org.sterling.runtime.expression.Argument;
import org.sterling.runtime.expression.BooleanConstant;
import org.sterling.runtime.expression.BoundExpression;
import org.sterling.runtime.expression.CharacterConstant;
import org.sterling.runtime.expression.Conditional;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.DoubleConstant;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.IntegerConstant;
import org.sterling.runtime.expression.Lambda;
import org.sterling.runtime.expression.MemberExpression;
import org.sterling.runtime.expression.ModuleExpression;
import org.sterling.runtime.expression.NullConstant;
import org.sterling.runtime.expression.ObjectExpression;
import org.sterling.runtime.expression.Reference;
import org.sterling.runtime.expression.StringConstant;
import org.sterling.runtime.expression.Symbol;
import org.sterling.runtime.expression.Variable;

public final class ExpressionFactory {
    public static final Variable SELF = ExpressionFactory.variable("self");

    public static AccessedExpression access(Expression object, Expression member) {
        return new AccessedExpression(object, member);
    }

    public static AppliedExpression apply(Expression lambda, Expression argument) {
        return new AppliedExpression(lambda, argument);
    }

    public static Argument argument(String identifier, Expression expression) {
        return ExpressionFactory.argument(ExpressionFactory.variable(identifier), expression);
    }

    public static Argument argument(Variable variable, Expression expression) {
        return new Argument(variable, expression);
    }

    public static BoundExpression bind(Expression lambda, Argument argument) {
        return new BoundExpression(lambda, argument);
    }

    public static Conditional conditional() {
        return Conditional.INSTANCE;
    }

    public static Expression conditional(Expression condition, Expression truePath, Expression falsePath) {
        return ExpressionFactory.apply(ExpressionFactory.apply(ExpressionFactory.apply(ExpressionFactory.conditional(), condition), truePath), falsePath);
    }

    public static BooleanConstant constant(boolean value) {
        return value ? BooleanConstant.TRUE : BooleanConstant.FALSE;
    }

    public static CharacterConstant constant(char value) {
        return new CharacterConstant(value);
    }

    public static DoubleConstant constant(double value) {
        return new DoubleConstant(value);
    }

    public static IntegerConstant constant(int value) {
        return new IntegerConstant(value);
    }

    public static StringConstant constant(String value) {
        return new StringConstant(value);
    }

    public static DeclaredExpression declaration(String identifier, Expression expression) {
        return ExpressionFactory.declaration(ExpressionFactory.symbol(identifier), expression);
    }

    public static DeclaredExpression declaration(Symbol symbol, Expression expression) {
        return new DeclaredExpression(symbol, expression);
    }

    public static Lambda lambda(Variable variable, Expression expression) {
        return new Lambda(variable, expression);
    }

    public static MemberExpression member(ObjectExpression object, Expression member) {
        return new MemberExpression(object, member);
    }

    public static ModuleExpression module(GlobalModule loader) {
        return ExpressionFactory.module(ExpressionFactory.symbol("global"), loader);
    }

    public static ModuleExpression module(Symbol symbol, GlobalModule loader) {
        return ExpressionFactory.module(symbol, loader, Collections.EMPTY_SET);
    }

    public static ModuleExpression module(Symbol symbol, GlobalModule loader, Set<DeclaredExpression> members) {
        return new ModuleExpression(symbol, loader, members);
    }

    public static ObjectExpression object(DeclaredExpression ... members) {
        return new ObjectExpression(new HashSet<DeclaredExpression>(Arrays.asList(members)));
    }

    public static NullConstant nothing() {
        return NullConstant.NULL;
    }

    public static Symbol symbol(String identifier) {
        return new Symbol(identifier);
    }

    public static Reference reference(String identifier, GlobalModule repository) {
        return new Reference(ExpressionFactory.symbol(identifier), repository);
    }

    public static Reference reference(String identifier) {
        return ExpressionFactory.reference(ExpressionFactory.symbol(identifier));
    }

    public static Reference reference(Symbol symbol) {
        return new Reference(symbol);
    }

    public static Variable variable(String identifier) {
        return new Variable(identifier);
    }

    private ExpressionFactory() {
    }
}

