/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.BooleanConstant;
import org.sterling.runtime.expression.DoubleConstant;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionConversions;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.util.StringUtil;

public class IntegerConstant
extends Expression {
    private final int value;

    public IntegerConstant(int value) {
        this.value = value;
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        switch (ExpressionConversions.convertSymbol(member).getValue()) {
            case "+": {
                return new AddClosure(this.value);
            }
            case "-": {
                return new SubtractClosure(this.value);
            }
            case "*": {
                return new MultiplyClosure(this.value);
            }
            case "/": {
                return new DivideClosure(this.value);
            }
            case "%": {
                return new ModuloClosure(this.value);
            }
            case "<<": {
                return new LeftShiftClosure(this.value);
            }
            case ">>": {
                return new SignedRightShiftClosure(this.value);
            }
            case ">>>": {
                return new RightShiftClosure(this.value);
            }
            case "&": {
                return new BitwiseAndClosure(this.value);
            }
            case "|": {
                return new BitwiseOrClosure(this.value);
            }
            case "^": {
                return new BitwiseXorClosure(this.value);
            }
            case "<": {
                return new LessThanClosure(this.value);
            }
            case "<=": {
                return new LessThanEqualsClosure(this.value);
            }
            case "positive": {
                return new IntegerConstant(Math.abs(this.value));
            }
            case "negative": {
                return new IntegerConstant(-this.value);
            }
            case "toBoolean": {
                return this.toBoolean();
            }
            case "toInteger": {
                return this;
            }
            case "toString": {
                return ExpressionFactory.constant(String.valueOf(this.value));
            }
            case "toDouble": {
                return new DoubleConstant(Integer.valueOf(this.value).doubleValue());
            }
        }
        return super.access(member);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof IntegerConstant && this.value == ((IntegerConstant)o).value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return StringUtil.stringify(this, this.value);
    }

    private BooleanConstant toBoolean() {
        return this.value == 1 ? BooleanConstant.TRUE : BooleanConstant.FALSE;
    }

    private static class LessThanEqualsClosure
    extends Expression {
        private final int value;

        public LessThanEqualsClosure(int value) {
            this.value = value;
        }

        @Override
        public Expression apply(Expression argument) throws SterlingException {
            return this.value <= ExpressionConversions.convertInteger(argument).value ? BooleanConstant.TRUE : BooleanConstant.FALSE;
        }
    }

    private static final class LessThanClosure
    extends Expression {
        private final int value;

        public LessThanClosure(int value) {
            this.value = value;
        }

        @Override
        public Expression apply(Expression argument) throws SterlingException {
            return this.value < ExpressionConversions.convertInteger(argument).value ? BooleanConstant.TRUE : BooleanConstant.FALSE;
        }
    }

    private static final class BitwiseXorClosure
    extends IntegerClosure {
        public BitwiseXorClosure(int value) {
            super(value);
        }

        @Override
        protected int operate(int leftValue, int rightValue) {
            return leftValue ^ rightValue;
        }
    }

    private static final class BitwiseOrClosure
    extends IntegerClosure {
        public BitwiseOrClosure(int value) {
            super(value);
        }

        @Override
        protected int operate(int leftValue, int rightValue) {
            return leftValue | rightValue;
        }
    }

    private static final class BitwiseAndClosure
    extends IntegerClosure {
        public BitwiseAndClosure(int value) {
            super(value);
        }

        @Override
        protected int operate(int leftValue, int rightValue) {
            return leftValue & rightValue;
        }
    }

    private static final class SignedRightShiftClosure
    extends IntegerClosure {
        public SignedRightShiftClosure(int value) {
            super(value);
        }

        @Override
        protected int operate(int leftValue, int rightValue) {
            return leftValue >> rightValue;
        }
    }

    private static final class RightShiftClosure
    extends IntegerClosure {
        public RightShiftClosure(int value) {
            super(value);
        }

        @Override
        protected int operate(int leftValue, int rightValue) {
            return leftValue >>> rightValue;
        }
    }

    private static final class LeftShiftClosure
    extends IntegerClosure {
        public LeftShiftClosure(int value) {
            super(value);
        }

        @Override
        protected int operate(int leftValue, int rightValue) {
            return leftValue << rightValue;
        }
    }

    private static final class ModuloClosure
    extends IntegerClosure {
        public ModuloClosure(int value) {
            super(value);
        }

        @Override
        protected int operate(int leftValue, int rightValue) {
            return leftValue % rightValue;
        }
    }

    private static final class DivideClosure
    extends IntegerClosure {
        public DivideClosure(int value) {
            super(value);
        }

        @Override
        protected int operate(int leftValue, int rightValue) {
            return leftValue / rightValue;
        }
    }

    private static final class MultiplyClosure
    extends IntegerClosure {
        public MultiplyClosure(int value) {
            super(value);
        }

        @Override
        protected int operate(int leftValue, int rightValue) {
            return leftValue * rightValue;
        }
    }

    private static final class SubtractClosure
    extends IntegerClosure {
        public SubtractClosure(int value) {
            super(value);
        }

        @Override
        protected int operate(int leftValue, int rightValue) {
            return leftValue - rightValue;
        }
    }

    private static final class AddClosure
    extends IntegerClosure {
        public AddClosure(int value) {
            super(value);
        }

        @Override
        protected int operate(int leftValue, int rightValue) {
            return leftValue + rightValue;
        }
    }

    private static abstract class IntegerClosure
    extends Expression {
        private final int value;

        public IntegerClosure(int value) {
            this.value = value;
        }

        @Override
        public Expression apply(Expression argument) throws SterlingException {
            return new IntegerConstant(this.operate(this.value, ExpressionConversions.convertInteger(argument).value));
        }

        public String toString() {
            return StringUtil.stringify(this, this.value);
        }

        protected abstract int operate(int var1, int var2);
    }
}

