/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.ExpressionVisitor;
import org.sterling.runtime.expression.Variable;
import org.sterling.util.StringUtil;

public class Lambda
extends Expression {
    private final Expression expression;
    private final Variable variable;

    public Lambda(Variable variable, Expression expression) {
        this.expression = expression;
        this.variable = variable;
    }

    @Override
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitLambda(this, data);
    }

    @Override
    public Expression apply(Expression argument) throws SterlingException {
        return ExpressionFactory.bind(this.expression, ExpressionFactory.argument(this.variable, argument));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Lambda) {
            Lambda other = (Lambda)o;
            return Objects.equals(this.variable, other.variable) && Objects.equals(this.expression, other.expression);
        }
        return false;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public int hashCode() {
        return Objects.hash(this.variable, this.expression);
    }

    public String toString() {
        return StringUtil.stringify(this, this.variable, this.expression);
    }
}

