/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionConversions;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.util.StringUtil;

public class Symbol
extends Expression {
    private final String value;

    public Symbol(String value) {
        this.value = value;
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        switch (ExpressionConversions.convertSymbol(member).getValue()) {
            case "toString": {
                return ExpressionFactory.constant(this.value);
            }
            case "toSymbol": {
                return this;
            }
        }
        return super.access(member);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Symbol && Objects.equals(this.value, ((Symbol)o).value);
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return StringUtil.stringify(this, this.value);
    }
}

