/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sterling.SterlingException;
import org.sterling.source.parser.ParserAction;
import org.sterling.source.parser.ParserRule;
import org.sterling.source.parser.ParserState;
import org.sterling.source.parser.TableDrivenParser;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.SourceNode;

public class ParserTable {
    private static final ParserAction ERROR = new ParserAction(){

        @Override
        public void invoke(TableDrivenParser parser) throws SterlingException {
            parser.error();
        }
    };
    private final Map<ParserState, ParserAction> table;
    private final Map<NodeKind, List<NodeKind>> lookAheadMap;
    private final ParserAction errorAction;

    private static Map<NodeKind, List<NodeKind>> initLookAheadMap(Collection<ParserRule> rules) {
        ConcurrentHashMap<NodeKind, List<NodeKind>> lookAheadMap = new ConcurrentHashMap<NodeKind, List<NodeKind>>();
        for (ParserRule rule : rules) {
            ParserState state = rule.getState();
            if (!lookAheadMap.containsKey((Object)state.getStack())) {
                lookAheadMap.put(state.getStack(), new CopyOnWriteArrayList());
            }
            ((List)lookAheadMap.get((Object)state.getStack())).add(state.getLookAhead());
        }
        return lookAheadMap;
    }

    private static Map<ParserState, ParserAction> initTable(Collection<ParserRule> rules) {
        ConcurrentHashMap<ParserState, ParserAction> stateActionMap = new ConcurrentHashMap<ParserState, ParserAction>();
        for (ParserRule rule : rules) {
            if (stateActionMap.containsKey(rule.getState())) {
                throw new IllegalArgumentException("Duplicate rule for parser state " + rule.getState());
            }
            stateActionMap.put(rule.getState(), rule.getAction());
        }
        return stateActionMap;
    }

    public ParserTable(Collection<ParserRule> rules) {
        this.lookAheadMap = ParserTable.initLookAheadMap(rules);
        this.table = ParserTable.initTable(rules);
        this.errorAction = ERROR;
    }

    public ParserAction getAction(ParserState state) {
        if (this.table.containsKey(state)) {
            return this.table.get(state);
        }
        return this.errorAction;
    }

    public ParserAction getErrorAction() {
        return this.errorAction;
    }

    public List<NodeKind> getLookAhead(SourceNode node) {
        NodeKind stack = node.getKind();
        if (this.hasLookAhead(stack)) {
            return new ArrayList<NodeKind>((Collection)this.lookAheadMap.get((Object)stack));
        }
        throw new IllegalStateException("No look-ahead tokens registered to " + (Object)((Object)stack));
    }

    private boolean hasLookAhead(NodeKind stack) {
        return this.lookAheadMap.containsKey((Object)stack);
    }
}

