/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.parser;

import java.util.LinkedHashSet;
import java.util.Set;
import org.sterling.source.exception.ParserException;
import org.sterling.source.parser.ParserAction;
import org.sterling.source.parser.ParserRule;
import org.sterling.source.parser.ParserState;
import org.sterling.source.parser.ParserTable;
import org.sterling.source.parser.ParserTableBuilder;
import org.sterling.source.parser.TableDrivenParser;
import org.sterling.source.syntax.NodeKind;

public class ParserTableActionBuilder {
    private static final ParserAction OUTPUT = new ParserAction(){

        @Override
        public void invoke(TableDrivenParser parser) throws ParserException {
            parser.output();
        }
    };
    private final ParserTableBuilder builder;
    private final NodeKind stack;
    private final Set<NodeKind> lookAhead;
    private boolean seenLookAhead;

    public ParserTableActionBuilder(ParserTableBuilder builder, NodeKind stack) {
        this.builder = builder;
        this.stack = stack;
        this.lookAhead = new LinkedHashSet<NodeKind>();
    }

    public ParserTableActionBuilder derive(NodeKind ... stack) {
        return this.then(new TableDrivenParser.Derive(stack));
    }

    public ParserTable getTable() {
        return this.builder.getTable();
    }

    public ParserTableActionBuilder or(NodeKind ... lookAhead) {
        this.shouldHaveLookAhead();
        this.addLookAhead(lookAhead);
        return this;
    }

    public ParserTableActionBuilder output() {
        return this.then(OUTPUT);
    }

    public ParserTableActionBuilder sees(NodeKind ... lookAhead) {
        if (this.seenLookAhead) {
            throw new IllegalStateException("Have already seen look-ahead tokens for stack " + (Object)((Object)this.stack));
        }
        this.seenLookAhead = true;
        this.addLookAhead(lookAhead);
        return this;
    }

    public ParserTableActionBuilder then(ParserAction action) {
        for (NodeKind lookAhead : this.lookAhead) {
            this.builder.addRule(ParserRule.rule(ParserState.state(this.stack, lookAhead), action));
        }
        return this;
    }

    public ParserTableActionBuilder tryDerive(NodeKind ... tries) {
        return this.then(new TableDrivenParser.TryDerive(tries));
    }

    public ParserTableActionBuilder when(NodeKind stack) {
        return new ParserTableActionBuilder(this.builder, stack);
    }

    private void addLookAhead(NodeKind[] lookAhead) {
        for (NodeKind kind : lookAhead) {
            if (this.lookAhead.contains((Object)kind)) {
                throw new IllegalStateException("Look-ahead " + (Object)((Object)kind) + " already added for stack " + (Object)((Object)this.stack));
            }
            this.lookAhead.add(kind);
        }
    }

    private void shouldHaveLookAhead() {
        if (!this.seenLookAhead) {
            throw new IllegalStateException("Have not seen look-ahead tokens for stack " + (Object)((Object)this.stack));
        }
    }
}

